package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.os.AsyncTask;

import java.util.ArrayList;
import java.util.List;

import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;

/**
 * AsyncTask to delete a Person from the DB.
 * This process is deletes the Person completely.
 * Created by david on 04.03.16.
 */
public class DeletePersonsInDb extends AsyncTask<Void, Integer, Boolean> {

    private Context mContext;
    private PersonDao personDao;
    private List<Person> mPersonsToDelete;
    private IDeletePersons iDeletePersons;
    private List<Integer> mDeletedPositions;

    public DeletePersonsInDb(Context context, List<Person> personsToDelete,
                             IDeletePersons iDeletePersons) {
        mContext = context;
        mPersonsToDelete = personsToDelete;
        this.iDeletePersons = iDeletePersons;
        mDeletedPositions = new ArrayList<>();
    }

    @Override
    protected Boolean doInBackground(Void... params) {
        List<Boolean> tries = new ArrayList<>();
        personDao = new PersonDao(mContext);
        personDao.openWritable();
        for (Person p : mPersonsToDelete) {
            mDeletedPositions.add(p.getPosition());
            tries.add(personDao.deletePerson(p));
        }
        int failCounter = 0;
        if (tries.size() == mPersonsToDelete.size()) {
            for (Boolean b : tries) {
                if (!b) {
                    failCounter++;
                }
            }
        }
        return failCounter == 0;
    }

    @Override
    protected void onPostExecute(Boolean isDeleted) {
        super.onPostExecute(isDeleted);
        personDao.close();
        iDeletePersons.onDeletedPersons(isDeleted, mDeletedPositions);
    }

    public interface IDeletePersons {
        void onDeletedPersons(Boolean isDeleted, List<Integer> deletedPositions);
    }
}
